TITLE   'Simple Magnet Coil'						  { 3d226.pde }
SELECT     errlim=5e-4   ngrid=1  spectral_colors	
COORDINATES     cartesian3			{ Professional Edition }
VARIABLES      Ax     Ay     Az
DEFINITIONS                      			
   L=1.0     r1=0.1     r2=0.2     z0=0.2     rad=sqrt( x^2+ y^2)
   mu0=4*pi*1e-7    mu=mu0     J00=1.0		{ Current density in coil }
   Bex=dy(Az)-dz(Ay)     Bey=dz(Ax)-dx(Az)     Bez=dx(Ay)-dy(Ax)
   B=vector( Bex, Bey, Bez)     Bm=magnitude( B)
   Hx=Bex/mu     Hy=Bey/mu     Hz=Bez/mu     Hm=Bm/mu	
   J0=0					 		{ Default current density }
   Jx=-J0*y/rad    Jy=J0*x/rad     Jz=0	
   J=vector( Jx, Jy, Jz)	
EQUATIONS
   Ax:		dx( dx(Ax)/mu)+ dy( dy(Ax)/mu)+ dz( dz(Ax)/mu)=-Jx
   Ay:		dx( dx(Ay)/mu)+ dy( dy(Ay)/mu)+ dz( dz(Ay)/mu)=-Jy
   Az:		dx( dx(Az)/mu)+ dy( dy(Az)/mu)+ dz( dz(Az)/mu)=-Jz
EXTRUSION						{ Parallel surfaces }
   surface 'bottom' z=-L	
   layer 'air 1'						{ Layer below coil }
   surface 'lower' z=-z0
   layer 'coil'						{ Layer containing coil }
   surface 'upper' z=z0
   layer 'air 2'						{ Layer above coil }
   surface 'top' z=L
BOUNDARIES
   surface 'bottom'  value(Ax)=0   value(Ay)=0   value(Az)=0
   surface 'top' value(Ax)=0   value(Ay)=0   value(Az)=0
region 'domain'						{ Full solution domain }	
   start (-L,-L) value(Ax)=0   value(Ay)=0   value(Az)=0			
   line to (L,-L)  to (L,L)  to (-L,L)  close
limited region 'coil'					{ Winding }
   layer 'coil' J0=1.0						
   start (r2,0) arc( center=0,0) angle=360
limited region 'hole'					{ Air space }
   layer 'coil' J0=0	
   start (r1,0) arc( center=0,0) angle=360
PLOTS
    vector( J) on z=0 on 'coil'
    vector( B) norm on x=0
    vector( B) norm on x=0 zoom(-0.4,-0.4,  0.8,0.8)
    vector( B) norm on z=0    vector( B) norm on z=L
    contour( Bm) painted on x=0
    contour( Bm) painted on y=0
END

